##########################################
# WB Pygames 2
# Autor: M. Schmid
##########################################

##########################################
# Externe Bibliotheken einbinden
##########################################
import pygame as py
from random import randint


##########################################
# Pygames initialisieren
##########################################
py.init()

# Fenstergrösse setzen
win_size = (800,800)
screen = py.display.set_mode(win_size)

# Titel des Fensters
py.display.set_caption("Pygames: Sprites")


#########################################################################
# Beginn der Klassendefinitionen
#########################################################################

# Bauplan für des Spielers
class Player(py.sprite.Sprite):
    def __init__(self): 
        super().__init__()

        # Bild laden
        self.image  = py.image.load("res/wheel0.gif").convert()

        # Rechteck ums Bild bestimmen und Koordinaten setzen
        self.rect   = self.image.get_rect()
        self.rect.x = randint(100,700)
        self.rect.y = randint(100,700)
        

##########################################
# Globale Funktionen definieren
##########################################

# Funktion, die die Tasten-Events überprüft
def key_handler():
    # Alle gedrückten Tasten abrufen und speichern
    key = py.key.get_pressed()

    # Ist die linke Pfeiltaste gedrückt worden?
    if key[py.K_LEFT] == True:                     
        pass


##########################################
# Globale Variabeln initialisieren
##########################################
game_is_running = True

# Eine Pygame-Uhr um die Framerate zu kontrollieren
clock = py.time.Clock()

# Framerate: fps = frames per second
fps = 60

# Einen Spieler/Sprite/Objekt erstellen
player1 = Player()

# Gruppen für die Sprite Objekte erstellen
all_sprites = py.sprite.Group()           

# Die Sprites/Objekte den entsprechenden Gruppen hinzufügen
all_sprites.add(player1)


##########################################
# Hauptschleife
##########################################
while game_is_running:
     
    ##########################################
    # Events abfragen
    ##########################################
    for event in py.event.get():
        # Wird das Fenster geschlossen, soll
        # auch das Spiel beendet werden
        if event.type == py.QUIT:
            game_is_running = False 
    
    # Wurde eine Taste gedrückt?
    key_handler()
    

    ##########################################
    # Alles zeichnen
    ##########################################

    # Hintergrund zeichnen = alles löschen
    screen.fill([255,255,255])

    # Alle Sprites in der jeweiligen Gruppe zeichnen
    all_sprites.draw(screen)                         
    
    # Alle Änderungen übernehmen
    # => Zeichne den Bildschirm neu
    py.display.update()

    # Der Bildschirm soll alle 1/24 Sekunden aktualisiert werden
    clock.tick(fps) 


##########################################
# Hauptschleife beendet -> Game Over
##########################################

##########################################
# Spiel ist beendet
##########################################
py.quit()