##########################################
# WB Pygames 2
# Autor: M. Schmid
##########################################

##########################################
# Externe Bibliotheken einbinden
##########################################
import pygame as py
from random import randint


##########################################
# Pygames initialisieren
##########################################
py.init()

# Fenstergrösse setzen
win_size = (800,800)
screen = py.display.set_mode(win_size)

# Titel des Fensters
py.display.set_caption("Pygames: Sprites")


#########################################################################
# Beginn der Klassendefinitionen
#########################################################################

# Bauplan für des Spielers
class Player(py.sprite.Sprite):
    def __init__(self): 
        super().__init__()

        # Bild laden
        self.image  = py.image.load("res/wheel0.gif").convert()

        # Rechteck ums Bild bestimmen und Koordinaten setzen
        self.rect   = self.image.get_rect()
        self.rect.x = randint(100,700)
        self.rect.y = randint(100,700)

        # Schrittweite
        self.step_size = randint(1, 10)


# Bauplan für das Bullet
class Bullet(py.sprite.Sprite):
    def __init__(self): 
        super().__init__()

        # Bild laden
        self.image  = py.image.load("res/bullet.png").convert_alpha()

        # Rechteck ums Bild bestimmen und Koordinaten setzen
        self.rect   = self.image.get_rect()
        self.rect.x = randint(100,700)
        self.rect.y = randint(100,700)
        

##########################################
# Globale Funktionen definieren
##########################################

# Funktion, die die Tasten-Events überprüft
def key_handler():
    # Alle gedrückten Tasten abrufen und speichern
    key = py.key.get_pressed()

    # Bedienung Spieler 1
    if key[py.K_LEFT]:
        if player1.rect.x - player1.step_size <= 0:
            player1.rect.x = 0
        else:
            player1.rect.x -= player1.step_size
    if key[py.K_RIGHT]:
        if player1.rect.x + player1.step_size + player1.rect.width >= win_size[0]:
            player1.rect.x = win_size[0] - player1.rect.width
        else:
            player1.rect.x += player1.step_size
    if key[py.K_UP]:
        if player1.rect.y - player1.step_size <= 0:
            player1.rect.y = 0
        else:
            player1.rect.y -= player1.step_size
    if key[py.K_DOWN]:
        if player1.rect.y + player1.step_size + player1.rect.height >= win_size[1]:
            player1.rect.y = win_size[1] - player1.rect.height
        else:
            player1.rect.y += player1.step_size
    
    # Bedienung Spieler 2
    if key[py.K_a]:
        if player2.rect.x - player2.step_size <= 0:
            player2.rect.x = 0
        else:
            player2.rect.x -= player2.step_size
    if key[py.K_d]:
        if player2.rect.x + player2.step_size + player2.rect.width >= win_size[0]:
            player2.rect.x = win_size[0] - player2.rect.width
        else:
            player2.rect.x += player2.step_size
    if key[py.K_w]:
        if player2.rect.y - player2.step_size <= 0:
            player2.rect.y = 0
        else:
            player2.rect.y -= player2.step_size
    if key[py.K_s]:
        if player2.rect.y + player2.step_size + player2.rect.height >= win_size[1]:
            player2.rect.y = win_size[1] - player2.rect.height
        else:
            player2.rect.y += player2.step_size
        
    #player3.rect.x, player3.rect.y = py.mouse.get_pos()
    

##########################################
# Globale Variabeln initialisieren
##########################################
game_is_running = True

# Eine Pygame-Uhr um die Framerate zu kontrollieren
clock = py.time.Clock()

# Framerate: fps = frames per second
fps = 60

# Einen Spieler/Sprite/Objekt erstellen
player1 = Player()
player2 = Player()
player2.image = py.image.load("res/disco.png").convert_alpha()
player2.rect   = player2.image.get_rect()

player3 = Bullet()

# Gruppen für die Sprite Objekte erstellen
all_sprites = py.sprite.Group()           

# Die Sprites/Objekte den entsprechenden Gruppen hinzufügen
all_sprites.add(player1, player2, player3)


##########################################
# Hauptschleife
##########################################
while game_is_running:
     
    ##########################################
    # Events abfragen
    ##########################################
    for event in py.event.get():
        # Wird das Fenster geschlossen, soll
        # auch das Spiel beendet werden
        if event.type == py.QUIT:
            game_is_running = False 
    
    # Wurde eine Taste gedrückt?
    key_handler()
    
    # Wurde eine Taste gedrückt?
    player3.rect.center = py.mouse.get_pos()

    ##########################################
    # Alles zeichnen
    ##########################################

    # Hintergrund zeichnen = alles löschen
    screen.fill([255,255,255])

    # Alle Sprites in der jeweiligen Gruppe zeichnen
    all_sprites.draw(screen)                         
    
    # Alle Änderungen übernehmen
    # => Zeichne den Bildschirm neu
    py.display.update()

    # Der Bildschirm soll alle 1/24 Sekunden aktualisiert werden
    clock.tick(fps) 


##########################################
# Hauptschleife beendet -> Game Over
##########################################

##########################################
# Spiel ist beendet
##########################################
py.quit()