##########################################
# Pygames - Group Kollisionen 
# Autor: M. Schmid
##########################################

##########################################
# Externe Bibliotheken einbinden
##########################################
import pygame as py
from random import randint


##########################################
# Pygames initialisieren
##########################################
py.init()

# Fenstergrösse setzen
win_size = (800,800)
screen = py.display.set_mode(win_size)

# Titel des Fensters
py.display.set_caption("Pygames: Gruppen Kollisionen und Endbildschirm")

# Schrift für den Text erstellen
my_font = py.font.SysFont('Comic Sans MS', 36)


#########################################################################
# Beginn der Klassendefinitionen
#########################################################################

# Bauplan für die Maus
class Mouse(py.sprite.Sprite):
    def __init__(self): 
        super().__init__()

        self.image  = py.image.load("./res/mouse.png").convert_alpha()

        # Rechteck ums Bild bestimmen und Koordinaten setzen
        self.rect   = self.image.get_rect()
        self.rect.x = win_size[0] / 2
        self.rect.y = win_size[1] / 2

        # Schrittweite
        self.step_size  = 5

        # Anazhl Punkte
        self.points = 0

        # Mask definieren, für die Pixel-Kollision
        self.mask = py.mask.from_surface(self.image)


# Bauplan für die Muenze
class Coin(py.sprite.Sprite):
    def __init__(self): 
        super().__init__()

        # Bilder laden und Startbild setzen 
        self.animation = load_images("res/", "coin", ".gif", 8, 80, 80)
        self.costume = 0
        self.image  = self.animation[self.costume]

        # Rechteck ums Bild bestimmen und Koordinaten setzen
        self.rect   = self.image.get_rect()
        self.rect.x = randint(100,700)
        self.rect.y = randint(100,700)

        # Mask definieren, für die Pixel-Kollision
        self.mask = py.mask.from_surface(self.image)
    
    # Das Objekt soll nach jedem Schleifendurchgang das Bild/Kostüm
    # wechseln. Dies geschieht in der "update"-Methode der Klasse
    def update(self):
        self.costume = (self.costume + 1 ) % len(self.animation)
        self.image  = self.animation[self.costume]
        self.mask = py.mask.from_surface(self.image)


###########################################
# Globale Funktionen definieren
##########################################

# Funktion, die die Tasten-Events überprüft
def key_handler():
    key = py.key.get_pressed()
    
    # Bedienung der Maus
    if key[py.K_LEFT]:
        if maus.rect.x - maus.step_size <= 0:
            maus.rect.x = 0
        else:
            maus.rect.x -= maus.step_size
    if key[py.K_RIGHT]:
        if maus.rect.x + maus.step_size + maus.rect.width >= win_size[0]:
            maus.rect.x = win_size[0] - maus.rect.width
        else:
            maus.rect.x += maus.step_size
    if key[py.K_UP]:
        if maus.rect.y - maus.step_size <= 0:
            maus.rect.y = 0
        else:
            maus.rect.y -= maus.step_size
    if key[py.K_DOWN]:
        if maus.rect.y + maus.step_size + maus.rect.height >= win_size[1]:
            maus.rect.y = win_size[1] - maus.rect.height
        else:
            maus.rect.y += maus.step_size

# Funktion: "load_images",
# die alle Bilder für eine Klasse lädt
#
# Eingaben:
#   - path = Pfad zum Ordner, wo die Bilder drin sind
#   - names = Bildernamen ohne Nummerierung
#   - ending = Bildformat, z.B. ".gif" oder anderes
#   - number = Anzahl Bilder, die geladen werden sollen
#   - xpix,ypix = Groesse des Bildes im Spiel 
#
# Ausgabe:
#   - Liste mit Pygame-Bildern
def load_images(path, names, ending, number, xpix, ypix):
    # In Animation werden die Pygame-Bilder gespeichert
    animation = []

    for i in range(number):
        file_name = path + names + str(i) + ending
        img = py.image.load(file_name).convert_alpha() 
        animation.append(py.transform.scale(img, (xpix, ypix)))

    return animation


# Funktion: "draw_score",
# die den aktuellen Kontostand im Fenster ausgibt
def draw_score(anzahl, zeit):
    text_string = "Anzahl verbleibende Münzen: " + str(anzahl)
    text_string += "   Zeit: " + str(zeit)
    text = my_font.render(text_string, True, [0, 0, 0]) 
    
    screen.blit(text, (win_size[0] / 2 - text.get_rect().width / 2 ,20))

# Funktion: "is_a_collision",
# die überprüft, ob die Maus eine Muenze beruehrt
# Bei einer Kollision, wird die Muenze entfernt
def is_a_collision():
    pass


##########################################
# Globale Variabeln initialisieren
##########################################
game_is_running = True

# Eine Pygame-Uhr um die Framerate zu kontrollieren
clock = py.time.Clock()

# Framerate: fps = frames per second
fps = 30

# Maus-Spieler wird erstellt
maus = Mouse()

# Gruppen für die Sprite Objekte erstellen
all_sprites = py.sprite.Group()           

# Die Sprites/Objekte den entsprechenden Gruppen hinzufügen
all_sprites.add(maus)

# Eine Muenze wird erstellt
anzahl_munzen = 1
munze = Coin()

all_sprites.add(munze)

# Startzeit für den Counter auf dem Bildschirm
start_zeit = py.time.get_ticks()


##########################################
# Hauptschleife
##########################################
while game_is_running:
    
    ##########################################
    # Events abfragen
    ##########################################
    for event in py.event.get():
        # Wird das Fenster geschlossen, soll
        # auch das Spiel beendet werden
        if event.type == py.QUIT:
            game_is_running = False

    
    # Zeit messen (in Sekunden)
    ende_zeit =   py.time.get_ticks()
    vergangene_zeit = (ende_zeit - start_zeit) // 1000

    
    ##########################################
    # Update Game State
    ##########################################

    # Wurde eine Taste gedrückt?
    key_handler()
    
    # Hat eine Beruehrung stattgefunden?
    if is_a_collision():
        game_is_running = False

    # Den Game-State der Sprites aktualisieren
    # Ruft auf allen Sprites die "update"-Funktion auf
    all_sprites.update()

    ##########################################
    # Alles zeichnen
    ##########################################
    # Hintergrund zeichnen = alles löschen
    screen.fill([255,255,255])

    # Alle Sprites in der jeweiligen Gruppe zeichnen
    all_sprites.draw(screen)  

    # Texte darstellen
    draw_score(anzahl_munzen, vergangene_zeit)
    
    py.display.update()
    clock.tick(fps)
   
##########################################
# Hauptschleife beendet -> Game Over
##########################################

##########################################
# Spiel ist beendet
##########################################
py.quit()