import pygame as py

####################################################
# Klassen für die Objekte                          #
####################################################
class Ship(py.sprite.Sprite):
    """This class represents the Space-Ship."""
    def __init__(self, x_pos = 200, y_pos = 200, lenge = 100, breite = 100, color = [0,255,0]):
        super().__init__()
        self.animation = load_images("res/ship/","ship0",".gif",4)
        self.image = self.animation[0]
        self.costume = 0
        self.rect = self.image.get_rect()
        self.rot_image = self.image
        self.set_pos(x_pos, y_pos)
        #self.mask = py.mask.from_surface(self.image)

    def set_pos(self, x, y):
        self.rect.x = x
        self.rect.y = y
        
    def add_pos(self, x, y):
        self.rect.x = self.rect.x + x
        self.rect.y = self.rect.y + y
        
    def update(self): 
        self.costume = (self.costume + 1) % 4 
        self.image = self.animation[self.costume]
        self.rot_rect()
        
    def rot_rect(self):
        center_coordinate = self.rect.center

        self.rot_image = py.transform.rotate(self.image, self.calc_angle())
        self.rect = self.rot_image.get_rect()
        self.rect.center = center_coordinate
        
    def calc_angle(self):
        mouse = py.Vector2(py.mouse.get_pos())
        ship = py.Vector2(self.rect.center)
        
        return -(ship - mouse).as_polar()[1] + 90
        
    def draw(self):
        screen.blit(self.rot_image, self.rect)
        


####################################################
# Hilfreiche Funktionen                            #
####################################################
def key_handler():
    key = py.key.get_pressed()
    
    if key[py.K_d]:
        space_ship.add_pos(5, 0)     
    if key[py.K_a]:
        space_ship.add_pos(-5, 0)   
    if key[py.K_w]:
        space_ship.add_pos(0, -5)
    if key[py.K_s]:
        space_ship.add_pos(0, 5)

def load_images(path, names, ending, number):
    file_names = []
    animation = []
    for i in range(number):  
        file_names.append(path + names + str(i) + ending)
        animation.append(py.image.load(file_names[i]).convert_alpha())              
    return animation



####################################################
# Start des Programms                              #
####################################################
py.init()

# Fenstergroesse und Konstanten
board_length = 800
board_height = 600
rotation_speed = 5

# Das Fenster erstellen
screen = py.display.set_mode((board_length, board_height), 0, 32)
py.display.set_caption('Ship rotate around the Mouse')

FPS = 60
fps_clock = py.time.Clock()

is_running = True

space_ship = Ship()
group_rect = py.sprite.Group()
group_rect.add(space_ship)


while is_running:
    screen.fill([255, 255, 255])

    for event in py.event.get():
        if event.type == py.QUIT or py.key.get_pressed()[py.K_ESCAPE]:
            is_running = False

    key_handler()

    space_ship.update()
    space_ship.draw()

    py.display.update()
    fps_clock.tick(FPS)

py.quit()
print("Programm beendet.")